#include <GUIConstantsEx.au3>
#include <StaticConstants.au3>
#include 'GroupCheckBox.au3'

Global $aCB_Data[][2] = _
	[ _
		['CheckBox1', 'Some data for CheckBox1'], _
		['CheckBox2', 'Some data for CheckBox2'], _
		['CheckBox3', 'Some data for CheckBox3'], _
		['CheckBox4', 'Some data for CheckBox4'], _
		['CheckBox5', 'Some data for CheckBox5'], _
		['CheckBox6', 'Some data for CheckBox6'] _
	]

$hGUI = GUICreate('GroupCheckBox Example 1', 310, 300)

GUICtrlCreateGroup('GroupCheckBox 1', 10, 10, 290, 110)
$hGroupCheckBox1 = _GroupCheckBox_Create($aCB_Data, 20, 30, -1, -1, 2, 30, 10)
$iCheckAll1_CB = GUICtrlCreateCheckbox('Check All', 20, 90)

$iStatus_Lbl = GUICtrlCreateLabel('', 20, 140, 270, 40, $SS_CENTER)
GUICtrlSetFont(-1, 8, 600)
GUICtrlSetColor(-1, 0x0000FF)

GUICtrlCreateGroup('GroupCheckBox 2', 10, 180, 290, 110)
$hGroupCheckBox2 = _GroupCheckBox_Create($aCB_Data, 20, 200, -1, -1, 2, 30, 10)
$iCheckAll2_CB = GUICtrlCreateCheckbox('Check All', 20, 260)

GUISetState(@SW_SHOW, $hGUI)

While 1
	$iMsg = GUIGetMsg()
	
	Switch $iMsg
		Case $GUI_EVENT_CLOSE
			_GroupCheckBox_Destroy($hGroupCheckBox1)
			_GroupCheckBox_Destroy($hGroupCheckBox2)
			Exit
		Case $iCheckAll1_CB, $iCheckAll2_CB
			$hGCB = $hGroupCheckBox1
			
			If $iMsg = $iCheckAll2_CB Then
				$hGCB = $hGroupCheckBox2
			EndIf
			
			$iState = $GCB_CHECK_STATE_NONE
			
			If GUICtrlRead($iMsg) = $GUI_CHECKED Then
				$iState = $GCB_CHECK_STATE_ALL
			EndIf
			
			_GroupCheckBox_SetState($hGCB, $iState, -1)
			ContinueCase
		Case Else
			$hGCB = $hGroupCheckBox1
			$iCA_CB = $iCheckAll1_CB
			$sGroup = 'GroupCheckBox 1:' & @CRLF
			
			Switch $iMsg
				Case _GroupCheckBox_GetEvent($hGroupCheckBox1, $iMsg), $iCheckAll1_CB
					
				Case _GroupCheckBox_GetEvent($hGroupCheckBox2, $iMsg), $iCheckAll2_CB
					$hGCB = $hGroupCheckBox2
					$iCA_CB = $iCheckAll2_CB
					$sGroup = 'GroupCheckBox 2:' & @CRLF
				Case Else
					ContinueLoop
			EndSwitch
			
			GUICtrlSetData($iStatus_Lbl, '')
			
			$iState = _GroupCheckBox_GetState($hGCB)
			
			Switch $iState
				Case $GCB_CHECK_STATE_ONE
					GUICtrlSetData($iStatus_Lbl, $sGroup & 'One (Or More) CheckBoxes Checked')
				Case $GCB_CHECK_STATE_ALL
					GUICtrlSetState($iCA_CB, $GUI_CHECKED)
					GUICtrlSetData($iStatus_Lbl, $sGroup & 'All CheckBoxes Checked.')
					
					$iCB = Random(1, _GroupCheckBox_GetInfo($hGCB), 1)
					$aInfo = _GroupCheckBox_GetInfo($hGCB, $iCB, $GCB_INDEX_ALL)
					
					If Not @error Then
						MsgBox(64, 'State', _
							StringFormat($sGroup & 'All CheckBoxes Checked.\n\nCheckBox #%i (Random) Info:\n\nCtrlID = %i\nText = %s\nParam = %s', _
								$iCB, $aInfo[$GCB_INDEX_CTRLID], $aInfo[$GCB_INDEX_TEXT], $aInfo[$GCB_INDEX_PARAM]), _
							0, $hGUI)
					EndIf
				Case $GCB_CHECK_STATE_NONE
					GUICtrlSetState($iCA_CB, $GUI_UNCHECKED)
					GUICtrlSetData($iStatus_Lbl, $sGroup & 'All CheckBoxes UnChecked.')
			EndSwitch
	EndSwitch
WEnd